function f = expeval(zz)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function f = expeval(zz)
% Given zz = [x;alpha], we calculate the vector of 
% residuals f in the fit of the data (t,y) by the
% function
%   ytest = sum x(i) exp(alpha(i) t)
%
%  expeval.m Dianne P. O'Leary   02/04
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global y t

n = length(zz);
n2 = n/2;
x = zz(1:n2);
alpha = zz(n2+1:n);

ytest = zeros(size(y));

for j=1:n2,
  ytest = ytest + exp(alpha(j)*t)*x(j);
end

f = y - ytest;

