function z = shooting(thetaprime)
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  function z = shooting(thetaprime)                     %
%  -- Shooting Method for Boundary Value Problems --     %
%  This function is used by fzero to determine how       %
%  close the value of theta(10) is to theta10 when       %
%  the initial conditions are (pi/8,thetaprime).         %
%                                                        %
%  thetaprime = trial value for theta'(0)                %
%  z = theta(10) - theta10                               %
%                                                        %
% Yalin Evren Sagduyu and Dianne P. O'Leary              %
% 12/02 and 01/03                                        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global theta10 % the actual boundary condition theta(10).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute the numerical solution to the linearized       %
% version of the differential equation describing the    %
% motion of a pendulum.                                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[t,y1]=ode45('pendulum',[0,10],[pi/32,thetaprime]); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Return the function value.                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

z=y1(length(y1),1)-theta10; 
