function [Q,R] = qrcolchange(Q,R,jindex,x)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function [Q,R] = qrcolchange(Q,R,jindex,x)
%
% Compute the QR factors of the matrix
%
%   QR + x e_{jindex}^T   
%
% where column jindex has been changed by x.
%
% qrcolchange.m  Dianne P. O'Leary 12/2005
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


[m,n] = size(R);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Update column jindex of R
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


R(:,jindex) = R(:,jindex) + Q'*x;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute rotations to reduce R to Hessenberg form.
% Update Q as R is changed.
%
%  R = [ x x x x x         [x x x x x
%          x x x x         [  x x x x
%          + x x x    -->  [  * x x x
%          +   x x         [    * x x
%          +     x         [      * x
%          +               [        *
%          +       ]       [          ]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    
for i=m:-1:jindex+1

    q = planerot(R(i-1:i,jindex));
    if (i-1>jindex)
       R(i-1:i,jindex) = q * R(i-1:i,jindex);
    end
    R(i-1:i,i-1:n)  = q * R(i-1:i,i-1:n);
    Q(:,i-1:i) = Q(:,i-1:i)*q';

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute rotations to reduce Hessenberg R to upper triangular form.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


for i=jindex:min(n,m-1)

    q = planerot(R(i:i+1,i));
    R(i:i+1,i:n) = q * R(i:i+1,i:n);
    Q(:,i:i+1) = Q(:,i:i+1)*q';

end

