function [fval,Q,newB] = f(angl)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function [fval,Q,newB] = f(angl)
%
% Given the three Euler angles in angl,
% produce the function value for nonlinear least squares:
% fval = || myB - Q myA ||_F
% where 
%   myB (passed through global) is a data matrix with 3 rows
%   myA (passed through global) is a data matrix 
%                               of the same size as myB
%   Q is an orthogonal matrix, computed from angl by 
%         compute_Q_from_angles
%   newB is Q times myA, the predicted position of the A data
%         after the transformation.
%
%  f.m Dianne P. O'Leary   06/2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global myA myB

Q = compute_Q_from_angles(angl);

newB = Q*myA;

fval = norm(myB - newB,'fro')^2;

