function [A,B,Q] = makedata(angl)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function [A,B,Q] = makedata(angl)
%
% Given the three Euler angles in angl,
% produce the data matrices A, B, and Q,
% where 
%   A is an 3x7 data matrix, specified below,
%     giving the data in Figure 1 of 
%     ``Achieving a Common Viewpoint: Yaw, Pitch, and Roll" 
%   Q is a 3x3 orthogonal matrix, computed from angl by 
%         compute_Q_from_angles
%   B = Q * A, giving the data positions 
%              after transformation
%
%  makedata.m Dianne P. O'Leary   06/2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


A      = [ 0     0     1     1     0    -1     0
           0     1     1     0     0     1     2
           0     1     2     3     4     4     4];

Q = compute_Q_from_angles(angl);

B = Q*A;
