
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This program creates Figure 1 of
%     ``Achieving a Common Viewpoint: Yaw, Pitch, and Roll"
%
%  molecule.m Dianne P. O'Leary   06/2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[x,y,z]=sphere(30);
x=x/sqrt(1.6);
y=y/sqrt(1.6);
z=z/sqrt(1.6);

n = 7;

center = [ 0     0     1     1     0    -1     0
           0     1     1     0     0     1     2
           0     1     2     3     4     4     4]

mymin = -1-1/sqrt(1.6);
mymax =  4+1/sqrt(1.6);

clf
sphere

for i=1:n,
  pos = center(:,i);
  surf(x+pos(1),y+pos(2),z+pos(3))
  hold on
end
lighting phong
h = findobj('Type','surface');
set(h, ...
      'SpecularStrength',1.0,'AmbientStrength',1.0)
       
light('Position',10*[1 3 2])
light('Position',10*[-3 -1 3])

cm = colormap;
for i=1:7,
   set(h(i),'EdgeColor','none', 'Facecolor',cm((i-1)*10+1,:))
%  set(h(i),'EdgeColor',cm((i-1)*10+1,:), 'Facecolor',cm((i-1)*10+1,:))
end
axis([mymin mymax mymin mymax mymin mymax])
axis vis3d off

angl = [-pi/9,pi/9,pi/6];

Q = compute_Q_from_angles(angl);

newcenter= Q*center;
figure(2)

for i=1:n,
  pos = newcenter(:,i);
  surf(x+pos(1),y+pos(2),z+pos(3))
  hold on
end
lighting phong
h = findobj('Type','surface');
set(h, ...
      'SpecularStrength',1.0,'AmbientStrength',1.0)

light('Position',10*[1 3 2])
light('Position',10*[-3 -1 3])

for i=1:7,
   set(h(i),'EdgeColor','none', 'Facecolor',cm((i-1)*10+1,:))
end

axis([mymin-.75 mymax-.75 mymin mymax mymin mymax])
axis vis3d off

figure(1)
print -depsc molecule1.eps
figure(2)
print -depsc molecule2.eps
