function A = BoxCarBlur(N, nbox)
%BOXCARBLUR: GIDE digital image deblurring.
% function A = BoxCarBlur(N, nbox)
%
% This function creates an N^2 x N^2 blurring matrix A 
% corresponding to a boxcar point-spread function (PSF) 
% of size nbox x nbox, assuming zero boundary conditions.
%
% Input: 
%   N    - The image is N x N.
%   nbox - The PSF is nbox x nbox if nbox is odd,
%                 (nbox-1) x (nbox-1) if nbox is even.
%
%  Example: If nbox = 3 or 4, the PSF is
%         1/9* [1, 1, 1; 
%               1, 1, 1; 
%               1, 1, 1]
%
% The matrix A is a symmetric, doubly block Toeplitz matrix 
% stored in sparse matrix format.
%
% Brianna Cash, Dianne P. O'Leary 11/2014
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Default: 

if (nargin < 2) 
   nbox = 3; 
end

% Compute the matrix A.

nbox = min(nbox,N);
if mod(nbox,2) == 0
   nbox = nbox - 1;
end

C = zeros(1,N);
R = zeros(1,N);

mylength = floor((nbox+1)/2);

C(1:mylength) = 1;
R(1:mylength) = 1;

A = toeplitz(C, R);

A = sparse(A);

A = kron(A,A)/nbox^2;

