function varargout = GIDE(varargin)
% GIDE M-file for GIDE.fig
%      GIDE, by itself, creates a new GIDE or raises the existing
%      singleton*.
%
%      H = GIDE returns the handle to a new GIDE or the handle to
%      the existing singleton*.
%
%      GIDE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in GIDE.M with the given input arguments.
%
%      GIDE('Property','Value',...) creates a new GIDE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before GIDE_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to GIDE_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES
% The code in this file was created using a MathWorks template.
% Brianna Cash 05/2013
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @GIDE_OpeningFcn, ...
                   'gui_OutputFcn',  @GIDE_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


%&&&&&&&&&&&&&&&&&&&&& function GIDE_OpeningFcn &&&&&&&&&&&&&&&&&&&&&&&&&&
% --- Executes just before GIDE is made visible.
function GIDE_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to GIDE (see VARARGIN)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Required to update handles output: 
% Choose default command line output for GIDE
handles.output = hObject;

handles.std2_input ='';
%
% Update handles structure
guidata(hObject, handles);
%
% UIWAIT makes GIDE wait for user response (see UIRESUME)
% uiwait(handles.figure1);
% END BLOCK of required code.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%&&&&&&&&&&&&&&&&&&&&&&&& function varargout &&&&&&&&&&&&&&&&&&&&&&&&&&&&&
% --- Outputs from this function are returned to the command line.
function varargout = GIDE_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
varargout{1} = handles.output;


%&&&&&&&&&&&&&&&&&&&& function Tik_Push_Callback &&&&&&&&&&&&&&&&&&&&&&&&&
% --- Executes on button press "Compute" (with handle name Tik_Push).
function Tik_Push_Callback(hObject, eventdata, handles)
% hObject    handle to Tik_Push (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%%%%%%%%%%%%%%%%%%%%%%%% BEGIN INITIALIZATION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Handle the user's choices for the solution algorithm and the problem.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Choose METHOD: 
% Default solution algorithm: Tikhonov (index_method == 1)
% index_method == 2 - Tikhonov (RestoreTool, Tikhonov.m)
% index_method == 3 - TSVD (RestoreTool, TSVD,m and GCVforSVD.m)
% index_method == 4 - TV Method (Brianna Cash, TVPrimDual.m, paramtest.m)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if handles.index_method ==2
    set(handles.compute, 'String', 'Computing Tikhonov method...')
elseif handles.index_method==3
    set(handles.compute, 'String', 'Computing TSVD method...')
elseif handles.index_method ==4
    set(handles.compute, 'String', 'Computing TV method (patience)...')
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Load Test Data:
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Defaults: 
x_true = [];
handles.leveln = .01;
handles.std2 = handles.leveln^2;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Choose IMAGE, std: 
% index_method == 2 - 16x16 piece of 'cell.tiff'
% index_method == 3 - 16x16 Modified Shepp-Logan
% index_method == 4 - blurred/noisy image found in MyData
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  
if handles.index_image == 2 

     handles.size_n = 16;
     handles.size_m = 16;
     x_true = TestImage(handles.size_n, 2);

elseif handles.index_image==3

     handles.size_n = 16;
     handles.size_m = 16;
     x_true = TestImage(handles.size_n, 3);

elseif handles.index_image==4

     [handles.b, ~, std] = MyData;
     handles.leveln = std;
     [handles.size_m , handles.size_n] = size(handles.b);
     handles.std2_input = num2str(std^2);
     handles.bn = handles.b(:);
     x_true = [];
     handles.x_true = [];
end
 
% If input space for std is not set to Default:  

if ~isempty(handles.std2_input)
     handles.std2= str2num(handles.std2_input);
     handles.leveln = sqrt(handles.std2);
end
 
handles.ileveln = 1/handles.leveln;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Choose BLUR: 
% index_method == 2 - Gaussian with sigma = .7 and band = 3 (3x3 PSF)
% index_method == 3 - Boxcar with band = 3 (3x3 PSF)
% index_method == 4 - Blur found in MyData 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if handles.index_blur == 2
         if handles.size_m> handles.size_n
             handles.size_m=handles.size_n;
         else
             handles.size_n=handles.size_m;
         end
         handles.A = GaussBlur(handles.size_n, 3, .7);
     
elseif handles.index_blur ==3
         if handles.size_m> handles.size_n
             handles.size_m=handles.size_n;
         else
             handles.size_n=handles.size_m;
         end
         
         k = 3; %size boxcar blur PSF
         handles.A = BoxCarBlur(handles.size_n, k);

elseif handles.index_blur ==4;
     [~, handles.A] = MyData;    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CREATE test problem:
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if ~isempty(x_true)
    x_true = x_true(1:handles.size_m, 1:handles.size_n);
    handles.x_true = x_true(:);
    handles.b = handles.A*handles.x_true;
end
% CREATE noise data:

handles.epsilon = randn(handles.size_m, handles.size_n);

% CREATE blurred and noisy data:

if handles.index_image < 4
   if handles.size_n<33
      handles.bn = handles.b+handles.leveln*handles.epsilon(:); 
   else
      handles.bn = handles.b+handles.leveln*handles.epsilon; 
   end
   handles.b = reshape(handles.bn, handles.size_m ,handles.size_n);

end


% Compute SNR = 10*log_10(||b||^2/||epsilon||^2) as defined in Windowed
%Spectral Regularization of Inverse Problems (J. Chung, G. Easley, D.O'Leary):

snr = 10*log10(norm(handles.bn(:))^2/norm(handles.leveln*handles.epsilon(:))^2);
set(handles.snr, 'String', snr);

% Set initial fields: 

set(handles.std, 'String', handles.std2);   % squared standard deviation of noise
set(handles.m,   'String', handles.size_m); % number of rows in image
set(handles.n,   'String', handles.size_n); % number of columns in image

% Blurred and noisy image
axes(handles.x_input)
imshow(reshape(handles.bn, handles.size_m, handles.size_n),[0,max(handles.bn(:))]), title('Blurred, noisy image')

% Use a blank white image in place of deblurred image in order
% to initialize axes to desired size.
axes(handles.x_output)
imshow(ones(handles.size_m, handles.size_n)); title('Results of deblurring')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%% BEGIN COMPUTATION of INITIAL SOLUTION %%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Compute the singular value decomposition (SVD) of the Blurring matrix: 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if isa(handles.A, 'double')
    A = full(handles.A);
    [handles.U, S, handles.V] = svd(A);
    handles.S = diag(S);
else
    [handles.U, handles.S, handles.V] = svd(handles.A);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% Compute regularized solution using the following methods 
% index_method == 2 - Tikhonov (RestoreTool, Tikhonov.m)
% index_method == 3 - TSVD (RestoreTool, TSVD,m and GCVforSVD.m)
% index_method == 4 - TV Method (Brianna Cash, TVPrimDual.m, paramtest.m)
% Default: Tikhonov 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if handles.index_method == 3
    %compute initial tol_trun:
    tol_trun = GCVforSVD(handles.S, handles.U'*handles.bn);
    %Where the percent truncation is given by: 
    handles.tol = tol_trun/(max(handles.S));
    %COMPUTE regularized solution for given tol:
    [x, ~] = TSVD(handles.U, handles.S, handles.V, handles.bn, handles.tol);
    %Set regularization parameter: 
    alpha = handles.tol; % = largest discarded singular value
elseif handles.index_method == 4
    beta = 0.01;
    dual = 1;
    alpha = 10^(-7); 
    nu = 1;
    handles.delta = norm(handles.leveln*handles.epsilon(:));
    try
        options = optimset('TolX', 10^(-9));
        % alphaD = regularization parameter from discrepancy principle 
        [alphaD,fval] = fzero(@(alpha) paramtest(alpha, handles.A, ...
            handles.b, beta, 2*nu, handles.delta, 20, 1.e-01), [0 1], options);
        alpha = alphaD; 
    end
    
    x = TVPrimDual(handles.A, handles.b, beta, alpha, [], 20, 1.e-4);
    handles.x_init = reshape(x, handles.size_m, handles.size_n);
    
    handles.x_init = x;
else  % x = restored image, alpha = Tikhonov regularization parameter
    [x, alpha] = Tikhonov(handles.U, handles.S, handles.V, handles.bn);
end
handles.alpha = alpha; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Set static fields for given information: 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

set(handles.alpha_text, 'String', handles.alpha); %set parameter: alpha for Tik and tol for TSVD

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Set static fields for given information: 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
axes(handles.x_output)
imshow(reshape(x(:), handles.size_m, handles.size_n),[0,max(x(:))]); 
title('Results of deblurring')
% Update handles structure

handles.Ax = handles.A*x(:);

%%%%%%%%%%%%%%%%%%%%%%%% BEGIN DIAGNOSTICS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Diagnostic 1: Residual norm test. See Diagnostic1.m for details.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
resid = handles.ileveln*(handles.Ax-handles.bn(:));


[yes, res, up, low]= Diagnostic1(resid);

if yes == 1
    set(handles.dia1, 'String', 'yes');
else 
    set(handles.dia1, 'String', 'no');
end

set(handles.res, 'String', res);
set(handles.up, 'String', up);
set(handles.low, 'String', low);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Diagnostic 2: Chi-Square test using Matlab's chi2gof.m.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%resid = handles.ileveln*(handles.Ax-handles.bn(:));
[X2test, p] = Diagnostic2(resid);

if X2test == 0
    set(handles.chi2gof, 'String', 'yes');
else 
    set(handles.chi2gof, 'String', 'no');
end

%display percent, if p >= 0.05, diagnostic is satisfied (95%): 
set(handles.p, 'String', p);
%display histogram: 
axes(handles.hist)
hist(resid, sqrt(size(handles.ileveln*handles.epsilon(:),1)));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Diagnostic 3: Cumulative Periodogram test. See Diagnostic3.m for details.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Display Cumulative Periodogram: 
axes(handles.CP)
[cp_yes, pct_in] = Diagnostic3(resid);
set(handles.prepts, 'String', pct_in); 

if cp_yes == 1
    set(handles.cptest, 'String', 'yes');
else 
    set(handles.cptest, 'String', 'no');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Determine Bounds on Slider (Log-Scale).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

handles.max1 = 0;
handles.min1 = -9;
          
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%SLIDER COMPUTATIONS%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Set Bounds and initial value of Slider by method: 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

set(handles.slider1,'Min', handles.min1);
set(handles.slider1, 'Max', handles.max1);
handles.max_O = 1;
handles.min_O = 1e-9;

%Rescale slide bar values: 
handles.max_S = max(handles.S(:))/3;  % DPO 01/2015
handles.min_S = min(1e-6, min(handles.S(:)));
handles.alpha ;
r_alpha = handles.min_O + (handles.max_O - handles.min_O)*(handles.alpha - handles.min_S)/(handles.max_S - handles.min_S);
%log_r_alpha = log(r_alpha)

set(handles.slider1,'Value', log(r_alpha)); %Set initial value (log)
set(handles.slider_editText,'String', num2str(handles.alpha));
set(handles.compute, 'String', '...done computing') 
guidata(hObject, handles);


%&&&&&&&&&&&&&&&&&&&& function slider1_Callback &&&&&&&&&&&&&&&&&&&&&&&&&&
% --- Executes on slider movement.
function slider1_Callback(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
%obtains the slider value from the slider component
 
if handles.index_method ==2
    set(handles.compute, 'String', 'Computing Tikhonov method...')
elseif handles.index_method==3
    set(handles.compute, 'String', 'Computing TSVD method...')
elseif handles.index_method ==4
    set(handles.compute, 'String', 'Computing TV method...')
end

sliderValue = get(handles.slider1,'Value'); %Log-scale
sliderValue = exp(sliderValue);
x_alpha = handles.min_S + (handles.max_S - handles.min_S)*(sliderValue - handles.min_O)/(handles.max_O - handles.min_O);
sliderValue = x_alpha;

% Put the slider value into the edit text component.
set(handles.slider_editText,'String', num2str(sliderValue));

% Update handles structure.
guidata(hObject, handles);

% Get the string for the editText component.
sliderValue = get(handles.slider_editText,'String');

% Convert from string to number if possible; otherwise returns empty.
sliderValue = str2double(sliderValue);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% For values determined by slider, compute output image and diagnostics.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
k=0;
if     handles.index_method == 2   
    x = Tikhonov(handles.U, handles.S, handles.V, handles.bn, sliderValue);
    
elseif handles.index_method == 3
    [x, ~] = TSVD(handles.U, handles.S, handles.V, handles.bn, sliderValue);

elseif handles.index_method == 4
    beta = 0.01;
               
    x = TVPrimDual(handles.A, handles.b, beta, sliderValue, ...
                     [], 20, 1.e-4);
  
end

handles.Ax = handles.A*x(:);
axes(handles.x_output) 
xmax = max(x(:));
imshow(reshape(x(:), handles.size_m, handles.size_n),[0,xmax]);
title('Results of deblurring');
resid = handles.ileveln*(handles.Ax-handles.bn(:));

%%%%%% DPO added %%%%%%%%%%%%%%%%%%%%
figure(1)
subplot(1,3,1)
imshow(handles.b,[0,xmax]);
title('Noisy, blurred image')
subplot(1,3,2)
if ~isempty(handles.x_true)
  imshow(reshape(handles.x_true(:),handles.size_m, handles.size_n),[0,xmax]);
else
  imshow(ones(handles.size_m, handles.size_n))
end
title('True image')
subplot(1,3,3)
imshow(reshape(x(:), handles.size_m, handles.size_n),[0,xmax]);
title('Results of deblurring')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Diagnostic 1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[yes, res, up, low]= Diagnostic1(resid);

if yes == 1
   set(handles.dia1, 'String', 'yes');
else 
   set(handles.dia1, 'String', 'no');
end

set(handles.res, 'String', res);
set(handles.up, 'String', up);
set(handles.low, 'String', low);

guidata(hObject, handles);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Diagnostic 2
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[X2test, p] = Diagnostic2(resid);
if X2test == 0
   set(handles.chi2gof, 'String', 'yes');
else 
   set(handles.chi2gof, 'String', 'no');
end
set(handles.p, 'String', p); 
axes(handles.hist)
hist(resid, sqrt(size(handles.epsilon(:),1)));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Diagnostic 3
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
axes(handles.CP)
[cp_yes, pct_in] = Diagnostic3(resid);
set(handles.prepts, 'String', pct_in); 
if cp_yes == 1
   set(handles.cptest, 'String', 'yes');
else 
   set(handles.cptest, 'String', 'no');
end

set(handles.compute, 'String', '...done computing') 


%&&&&&&&&&&&&&&&&&&&& function method_Callback  &&&&&&&&&&&&&&&&&&&&&&&&&&
% --- Executes on selection change in method.
% Sets index_method when method is chosen.
function method_Callback(hObject, eventdata, handles)
% hObject    handle to method (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns method contents as cell array
%        contents{get(hObject,'Value')} returns selected item from method
handles.index_method = get(hObject,'Value');
list = get(hObject,'String');
item_selected = list{handles.index_method};
guidata(hObject, handles);


%&&&&&&&&&&&&&&&&&&&&& function image_Callback  &&&&&&&&&&&&&&&&&&&&&&&&&&
% --- Executes on selection change in image.
% Sets index_image.
function image_Callback(hObject, eventdata, handles)
% hObject    handle to image (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns image contents as cell array
%        contents{get(hObject,'Value')} returns selected item from image

handles.index_image = get(hObject,'Value');
list = get(hObject,'String');
item_selected = list{handles.index_image};
guidata(hObject, handles);


%&&&&&&&&&&&&&&&&&&&&& function blur_Callback  &&&&&&&&&&&&&&&&&&&&&&&&&&&
% --- Executes on selection change in blur.
function blur_Callback(hObject, eventdata, handles)
% hObject    handle to blur (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns blur contents as cell array
%        contents{get(hObject,'Value')} returns selected item from blur

handles.index_blur = get(hObject,'Value');
list = get(hObject,'String');
item_selected = list{handles.index_blur};
guidata(hObject, handles);


%&&&&&&&&&&&&&&&&&&&&&& function std_Callback  &&&&&&&&&&&&&&&&&&&&&&&&&&&
function std_Callback(hObject, eventdata, handles)
% % % hObject    handle to std (see GCBO)
% % % eventdata  reserved - to be defined in a future version of MATLAB
% % % handles    structure with handles and user data (see GUIDATA)
% %If the user specifies the variance in GUI, else assumes the default or user
% %provided variance in MyData.m: 

handles.std2_input = get(hObject,'String');
guidata(hObject, handles);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The following code sets up pieces of the GUI.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%&&&&&&&&&&&&&&&&&&&&&& function method_CreateFcn &&&&&&&&&&&&&&&&&&&&&&&&
% --- Executes during object creation, after setting all properties.
function method_CreateFcn(hObject, eventdata, handles)
% hObject    handle to method (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%&&&&&&&&&&&&&&&&&&&&&&& function m_CreateFcn  &&&&&&&&&&&&&&&&&&&&&&&&&&&
% --- Executes during object creation, after setting all properties.
function m_CreateFcn(hObject, eventdata, handles)
% hObject    handle to m (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%&&&&&&&&&&&&&&&&&&&&&&& function n_CreateFcn  &&&&&&&&&&&&&&&&&&&&&&&&&&&
% --- Executes during object creation, after setting all properties.
function n_CreateFcn(hObject, eventdata, handles)
% hObject    handle to n (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%&&&&&&&&&&&&&&&&&&&&&& function std_CreateFcn  &&&&&&&&&&&&&&&&&&&&&&&&&&
% --- Executes during object creation, after setting all properties.
function std_CreateFcn(hObject, eventdata, handles)
% hObject    handle to std (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%&&&&&&&&&&&&&&&&&&&& function compute_CreateFcn  &&&&&&&&&&&&&&&&&&&&&&&
% --- Executes during object creation, after setting all properties.
function compute_CreateFcn(hObject, eventdata, handles)
% hObject    handle to compute (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%&&&&&&&&&&&&&&&&&&&&& function image_CreateFcn &&&&&&&&&&&&&&&&&&&&&&&&&&
% --- Executes during object creation, after setting all properties.
function image_CreateFcn(hObject, eventdata, handles)
% hObject    handle to image (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%&&&&&&&&&&&&&&&&&&&& function slider1_CreateFcn &&&&&&&&&&&&&&&&&&&&&&&&&
% --- Executes during object creation, after setting all properties.
function slider1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.

if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


%&&&&&&&&&&&&&&&&&&&&& function blur_CreateFcn &&&&&&&&&&&&&&&&&&&&&&&&&&&
% --- Executes during object creation, after setting all properties.
function blur_CreateFcn(hObject, eventdata, handles)
% hObject    handle to blur (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
