function [b, A, std] = MyData
%MYDATA: GIDE Example interface
% function [b, A, std] = MyData
%
% This function illustrates how to enter a new
% example problem into GIDE.
%
% To use your own problem, change this code
% to initialize these three variables:
%
%   b - blurred/noisy image of size m x n
%   A - blurring matrix of size mn x mn
% std - standard deviation of the noise in b.
%
% Brianna Cash, Dianne P. O'Leary 05/2013

load satellite.mat

% The file satellite.mat in RestoreTools/TestData contains
%   PSF         256x256     a point-spread function
%   b           256x256     a blurred image                    
%   x_true      256x256     a true image (which we do not use)

% We add random noise, with standard deviation 1.e-5, to b.

[m, n] = size(b);
std = 1e-5;
b= b + std.*randn(m, n);

% We create the blurring matrix A from PSF.

A = psfMatrix(PSF);

