function [ x_true ] = TestImage( N, num )
%TESTIMAGE: GIDE digital image deblurring
% function [ x_true ] = TestImage( N, num )
%
% This function generates a test image x_true of size N x N
% where the image is
%    random               if num=1
%    cell                 if num=2
%    Modified Shepp-Logan if num=3.
%
% Any other value of num creates a zero image.
%
% Brianna Cash, Dianne P. O'Leary, 05/2013
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

x_true = zeros(N,N);

if num ==1       % Random image.

    x_true = rand(N, N);

elseif num == 2  % Cell image from Matlab image toolbox.

    x_true = imread('cell.tif');
    x_true = mat2gray(x_true);
    x_true = x_true(1:N, 1:N);

elseif num==3    % Modified Shepp-Logan image from Matlab image toolbox.

    x_true = phantom('Modified Shepp-Logan', N);

end

