function [yes, resnorm2, up, low, m] = Diagnostic1(resid)
%DIAGNOSTIC1: GIDE digital image deblurring                    
%function [yes, resnorm2, up, low, m] = Diagnostic1(resid)
%
% This function determines whether "Diagnostic 1" is satisfied,
% testing whether the input vector has elements that are samples 
% from a normal distribution with mean 0 and standard deviation 1.
%
% The sum of squares of the samples should be distributed as 
% Chi-squared with m degrees of freedom, where m is the
% length of the vector.

% The answer is "yes" if the sum of squares is within the 95% 
% confidence interval for Chi-squares.
% 
% Therefore, we want to see if resnorm2 = || resid ||_2^2 is 
% within [m-2*sqrt(2*m), m+2*sqrt(2*m)] .
%
% Input:
%
%   resid - vector of length m
%
% Output:
%   yes      - 1 if diagnostic is satisfied, 0 otherwise
%   resnorm2 - residual norm-squared
%   up       - upper bound  m+2*sqrt(2*m)
%   low      - lower bound  m-2*sqrt(2*m)
%   m        - number of elements in the residual
%
% Based on 
% B.W. Rust and D.P. O'Leary, Residual periodograms for choosing 
% regularization parameters for ill-posed problems, 
% Inverse Problems, 24 (2008) 034005 
%
% Brianna Cash 2012
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% Compute the norm squared:

resnorm2 = (norm(resid))^2;

% Determine m and make the test:

m = length(resid);

up  = m+2*sqrt(2*m);
low = m-2*sqrt(2*m);

yes =  (resnorm2 >= low) && (resnorm2 <= up);

