function [X2test, p] = Diagnostic2(resid)
%DIAGNOSTIC2: GIDE digital image deblurring
% function [X2test, p] = Diagnostic2(resid)
% 
% This function determines whether "Diagnostic 2" is satisfied,
% testing whether the input vector has elements that are samples 
% from a normal distribution with mean 0 and standard deviation 1.
%
% It uses Matlab's chi2gof (Statistics Toolbox), which bins the 
% elements of the input vector and compares the actual counts to 
% those predicted from theory.
%
% Input:
%
%  resid - vector of length m
%
% Diagnostic 2: The vector resid should pass the Chi-squared
% goodness-of-fit test with the null hypothesis that the data 
% are a random sample from a normal distribution.
%
% Output: 
%
%  X2test - 0 if the residual satisfies the null hypothesis 
%           at 95% significance
%  p      - the p-value of the test, from Matlab's chi2gof:
%           "The p value is the probability, under 
%           assumption of the null hypothesis, of observing
%           the given statistic or one more extreme."
%
% Based on 
% B.W. Rust and D.P. O'Leary, Residual periodograms for choosing 
% regularization parameters for ill-posed problems, 
% Inverse Problmes, 24 (2008) 034005 
%
% Brianna Cash 2012
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Compute the goodness-of-fit test using Matlab's 'chi2gof'
% (Statistical Toolbox)

[X2test,p] = chi2gof(resid,'cdf',@normcdf);
