% This script starts GIDE, A GUI for Image Deblurring Exploration.
%
% For more information, see the user's manual
% "A Guide to GIDE: A GUI for Image Deblurring Exploration"
% at http://www.cs.umd.edu/users/oleary/software
%
% Brianna Cash and Dianne P. O'Leary
% University of Maryland
% 2014

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% BEFORE RUNNING THIS SCRIPT:                                           %
%   Change the following two statements so that they contain the        %
%   paths to the directories where you installed RestoreTools and GIDE. %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

path_to_RestoreTools = '/Users/oleary/GIDE/RestoreTools';
path_to_GIDE         = '/Users/oleary/GIDE';       

% The following statements establish the paths to files in RestoreTools.

fc = fullfile(path_to_RestoreTools,'Classes');
fd = fullfile(path_to_RestoreTools,'TestData');
fi = fullfile(path_to_RestoreTools,'IterativeMethods');
ft = fullfile(path_to_RestoreTools,'DirectMethods');

addpath (path_to_RestoreTools, fc, fd, fi, ft);

% The following statements establish the paths to files in GIDE.

fg = fullfile(path_to_GIDE,'GUI_Interface');
fr = fullfile(path_to_GIDE,'ResidDiagnostics');
fv = fullfile(path_to_GIDE,'TotalVariation');

addpath (path_to_GIDE, fg, fr, fv)

% Now start GIDE.

GIDE

