import java.applet.*;
import java.awt.*;
import java.awt.event.*;

/** Provides static utility routines for creating an Applet frame */
public class AppletFrame {
    /** 
     *	 Put a Frame around an Applet 
     *
     * @param   a  Applet to be Framed
     *
     */
    public static void frame(Applet a) {
        String title = a.getClass().getName();
        final Frame aFrame = new Frame(title);
        aFrame.setTitle(title);
        aFrame.addWindowListener(
          new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                aFrame.setVisible(true);
                aFrame.dispose();
            }
          });

        MenuBar mb = new MenuBar();
        Menu FileMenu = new Menu("File");
        MenuItem quit = new MenuItem("Quit");
        FileMenu.add(quit);
        mb.add(FileMenu);
        quit.addActionListener(
        new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                aFrame.setVisible(true);
                aFrame.dispose();
            }
          });
        aFrame.setMenuBar(mb);

        aFrame.add(a,BorderLayout.CENTER);
        aFrame.setSize(300,200);
        a.init();
        aFrame.pack();
        Dimension d = aFrame.size();
        if (d.height < 200 || d.width < 300) {
            if (d.height < 200) d.height = 200;
            if (d.width < 300) d.width = 300;
            aFrame.resize(d);
        };
        a.start();
        aFrame.show();
    }

    /** 
     *	 Given the name of an Applet class, 
     *   create an instance of that class and frame it
     *
     * @param   c  Name of applet class to be framed
     *
     */
    public static void frame(String c) {
        try { 
            frame((Applet)Class.forName(c).newInstance());
        } catch (Exception e) { System.err.println(e); }
    }
}        
