import java.util.*;
import java.awt.*;
import java.applet.*;

/** Same as Clock.java, except doesn't extend FlickerFreeApplet
 */
public class Clock0 extends Applet implements Runnable {
    Thread timer = null;
    Date dummy = new Date();
    Font font;

    public void drawCenteredString(Graphics g, String s, int x, int y) {
        FontMetrics fm = g.getFontMetrics();
        int width = fm.stringWidth(s);
        int ascent = fm.getAscent();
        g.drawString(s, x-width/2, y+ascent/2);
    }

    public void paint(Graphics g) {
        int xh, yh, xm, ym, xs, ys, s, m, h, xcenter, ycenter;
        String now;
        Date dat = new Date();
        Dimension d = size();

        s = dat.getSeconds();
        m = dat.getMinutes();
        h = dat.getHours();
        now = dat.toLocaleString();

        FontMetrics fm = g.getFontMetrics();

        int bottomWindow = 3*(fm.getAscent() + fm.getDescent())/2;
        xcenter=d.width/2;
        ycenter=(d.height- bottomWindow)/2;

        int charBox = Math.max(fm.stringWidth("12"),fm.getAscent())/2 + 1;
        int radius = Math.min(d.width-5,d.height-5-bottomWindow)/2;

        if (radius < 30) return;

        // a= s* pi/2 - pi/2 (to switch 0,0 from 3:00 to 12:00)
        // x = r(cos a) + xcenter, y = r(sin a) + ycenter

        xs = (int)(Math.cos(s * 3.14f/30 - 3.14f/2) * radius * 0.9+ xcenter);
        ys = (int)(Math.sin(s * 3.14f/30 - 3.14f/2) * radius * 0.9 + ycenter);
        xm = (int)(Math.cos(m * 3.14f/30 - 3.14f/2) * radius * 0.7 + xcenter);
        ym = (int)(Math.sin(m * 3.14f/30 - 3.14f/2) * radius * 0.7 + ycenter);
        xh = (int)(Math.cos((h*30 + m/2) * 3.14f/180 - 3.14f/2) * radius * 0.5 + xcenter);
        yh = (int)(Math.sin((h*30 + m/2) * 3.14f/180 - 3.14f/2) * radius * 0.5 + ycenter);

        // Draw the circle and numbers

        g.setFont(font);
        g.setColor(Color.blue);
        g.drawOval(xcenter-radius,ycenter-radius,2*radius,2*radius);
        g.setColor(Color.darkGray);
        drawCenteredString(g,"9", xcenter-radius+charBox,ycenter); 
        drawCenteredString(g,"3", xcenter+radius-charBox,ycenter);
        drawCenteredString(g,"12",xcenter,ycenter-radius+charBox);
        drawCenteredString(g,"6", xcenter,ycenter+radius-charBox);

        g.setColor(Color.darkGray);
        int stringY = d.height - 3*fm.getAscent()/4 - 5*fm.getDescent()/4;
        xcenter=d.width/2;
        if (fm.stringWidth(now) < d.width-4) 
            drawCenteredString(g,now, xcenter, stringY);
        g.drawLine(xcenter, ycenter, xs, ys);
        g.setColor(Color.blue);
        g.drawLine(xcenter, ycenter-1, xm, ym);
        g.drawLine(xcenter-1, ycenter, xm, ym);
        g.drawLine(xcenter, ycenter-1, xh, yh);
        g.drawLine(xcenter-1, ycenter, xh, yh);
    }

    public void start() {
        setBackground(Color.white);
        font = new Font("TimesRoman", Font.PLAIN, 14);
        if(timer == null) {
            timer = new Thread(this);
            timer.start();
        }
    }

    public void stop() {
        timer = null;
    }

    public void run() {
        while (timer != null) {
            try {
                Thread.sleep(1000);
            } 
            catch (InterruptedException e){
            }
            repaint();
        }
        timer = null;
    }

}
