import java.applet.Applet;
import java.awt.*;
import java.util.Date;

public class CountDown extends FlickerFreeApplet implements Runnable {
    private Font f;
    private FontMetrics  fm;
    private long target;
    private Thread timer;
    private String prefix;

    public void init() {
        try {
            prefix = getParameter("prefix");
            if (prefix == null) prefix = "";
            String bgColor = getParameter("bgColor");
            if (bgColor == null) bgColor = "ffffff";
            setBackground(new Color(Integer.parseInt(bgColor,16)));
        }
        catch (Exception e) {
            setBackground(Color.white);
        }

        try {
            String fgColor = getParameter("fgColor");
            if (fgColor == null) fgColor = "0";
            setForeground(new Color(Integer.parseInt(fgColor,16)));
        }
        catch (Exception e) {
            setForeground(Color.black);
        }

        target = new Date(getParameter("date")).getTime();

	f = null;
        try {
           String fontName = getParameter("fontName");
           if (fontName == null) fontName="TimesRoman";
           int fontSize = Integer.getInteger("fontSize",18).intValue();
           f = new Font(fontName,Font.BOLD,fontSize);
	   }
	catch (Exception e) {}

        if (f == null) f = new Font("TimesRoman",Font.BOLD,18);
        setFont(f);
        fm = getFontMetrics(f);
    }

    public void start() {
        if(timer == null)
        {
            timer = new Thread(this);
            timer.start();
        }
    }

    public void stop() {
        timer = null;
    }

    public void run() {
        while (timer != null) {
            try { Thread.sleep(800); } 
            catch (InterruptedException e){ }
            repaint();
        }
        timer = null;
    }

    public void paint(Graphics g)
    {
        long millisecondsRemaining = target - System.currentTimeMillis();
        String msg =  prefix + " - ";
        if (millisecondsRemaining < 0) {
            millisecondsRemaining = -millisecondsRemaining;
            msg = "+ ";
        }
        long secondsRemaining = millisecondsRemaining/1000;
        long secs = secondsRemaining%60;
        long mins = secondsRemaining/60%60;
        long hrs = secondsRemaining/3600%24;
        long days = secondsRemaining/3600/24;
        // long tenths = millisecondsRemaining/100%10;
        if (days > 0) msg += days + ":";
        if (hrs <10) msg += " " + hrs + ":";
        else msg += hrs + ":";
        if (mins <10) msg += " " + mins + ":";
        else msg += mins + ":";
        if (secs <10) msg += " " + secs;
        else msg += secs;
        // msg += "." + tenths;

        Dimension d = size();

        // int msgHeight = fm.getAscent() + fm.getDescent();
        int msgWidth = fm.stringWidth(msg);
        int left = d.width-msgWidth;
        int top = 0;
        int baseLine = top + fm.getAscent();
        g.drawString(msg, left, baseLine);
    }
}
