import java.awt.*;
import java.awt.event.*;

/** A toy example to show how event handling works in 1.1 AWT */

public class EventHandling {
    GUI gui = new GUI();
    void search(ActionEvent e) { 
        System.out.println("Search: " + e); 
    }
    void sort(ActionEvent e)   { 
        System.out.println("Sort: " + e); 
    }
    void check(ItemEvent e)    { 
        System.out.println("Check: " + e); 
    }
    void text(ActionEvent e)   { 
        System.out.println("Text event: " + e); 
    }
    void text(TextEvent e)     { 
        System.out.println("Text: " + e); 
    }
    static public void main(String args[]) {
        EventHandling app = new EventHandling();
    }
    class GUI extends Frame {   // Innerclass of EventHandling
        public GUI() {
            super("EventHandling");
            setLayout(new FlowLayout());
            Button b;
            add(b = new Button("Search"));
            b.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) { 
                    search(e); 
                }
            }
            );
            add(b = new Button("Sort"));
            b.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) { 
                    sort(e); 
                }
            }
            );
            Checkbox cb;
            add( cb = new Checkbox("alphabetical"));
            cb.addItemListener(
            new ItemListener() {
                public void itemStateChanged(ItemEvent e) { 
                    check(e); 
                }
            }
            );

            Choice c;
            add ( c = new Choice());
            c.addItem("Red");
            c.addItem("Green");
            c.addItem("Blue");
            c.addItemListener(
            new ItemListener() {
                public void itemStateChanged(ItemEvent e) { 
                    check(e); 
                }
            }
            );
            TextField tf;
            add(tf = new TextField(8));
            tf.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) { 
                    text(e); 
                }
            }
            );
            tf.addTextListener(
            new TextListener() {
                public void textValueChanged(TextEvent e) { 
                    text(e); 
                }
            }
            );
            pack(); 
            show();
        }
    }
}
