import java.util.StringTokenizer;
import java.applet.*;
import java.awt.*;
import java.awt.event.*;

/** Applet to demonstrate the FlowLayout */

public class FlowLayoutTest extends Applet {
    Panel buttonPanel;
    String msg;
    boolean textNeedsUpdate = true;
    boolean stopped = false; 
    boolean running = false; 

    TextArea buttonSource;
    FlowLayout buttonLayout;
    CheckboxGroup cbg;
    Checkbox left, center, right;

    synchronized void checkText() {
        if (textNeedsUpdate) {
            msg = buttonSource.getText();
            setButtons();
            textNeedsUpdate = false;
        }
    }

    void setButtons() { 
        buttonPanel.removeAll();
        StringTokenizer tokens 
            = new StringTokenizer(msg, " \t\n");
        while (tokens.hasMoreTokens()) 
            buttonPanel.add(new java.awt.Button(tokens.nextToken()));
        buttonPanel.validate();
    }

    public void init() {

        setLayout(new BorderLayout());

        buttonSource = new TextArea(
        "The quick brown fox jumped over the lazy dog.\n"
            + "Now is the time for all good men to come to the aid of their country.",
        4,40,TextArea.SCROLLBARS_NONE);
        add(buttonSource,BorderLayout.NORTH);
        buttonSource.addTextListener( new TextListener() {
            public void textValueChanged(TextEvent e) {
                synchronized (FlowLayoutTest.this) {
                    textNeedsUpdate = true;
                }
            }
        }
        );

        buttonPanel = new Panel();
        add(buttonPanel,BorderLayout.CENTER);
        buttonLayout = new FlowLayout();
        buttonPanel.setLayout(buttonLayout);

        class AlignmentChanger implements ItemListener {
            int alignment;
            public AlignmentChanger(int a) { 
                alignment = a; 
            };
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == ItemEvent.SELECTED) {
                    buttonLayout.setAlignment(alignment);
                    buttonPanel.invalidate();
                    buttonPanel.validate();
                }
            }
        };
        cbg = new CheckboxGroup();
        left = new Checkbox("left", false, cbg);
        left.addItemListener( new AlignmentChanger(FlowLayout.LEFT) );
        center = new Checkbox("center", true, cbg);
        center.addItemListener( new AlignmentChanger(FlowLayout.CENTER) );
        right = new Checkbox("right", false, cbg);
        right.addItemListener( new AlignmentChanger(FlowLayout.RIGHT) );

        Panel sPanel = new Panel();
        add(sPanel,BorderLayout.SOUTH);
        sPanel.add(left);
        sPanel.add(center);
        sPanel.add(right);
    } 

    public synchronized void start() {
        stopped = false;
        if (!running) {
            running = true;
            (new Thread() {
                public void run() {
                    while (true) {
                        synchronized (FlowLayoutTest.this) {
                            if (stopped) {
                                running = false;
                                break;
                            }
                            checkText();
                        }
                        try { 
                            sleep(1500); 
                        }
                        catch (InterruptedException e) {
                        };
                    }
                }
            }
            ).start();
        }

    }
    public synchronized void stop() {
        stopped = true;
    }

}
