import java.awt.*;
import java.applet.Applet;

/** Simple demonstration of GridBagLayout 
 *
 *  shows result of changing gridwidth and gridheight
 *
 */

public class GridBagLayoutTest extends Applet
{
    class RedButton extends java.awt.Button {
        public RedButton(String label) {
            super(label);
            setBackground(Color.red);
        }
    }

    public void init() {
        setFont(new Font("SansSerif",Font.PLAIN,9));
        setLayout(new GridBagLayout());
        GridBagConstraints  c  = new GridBagConstraints();
        c.gridwidth = c.gridheight=1;
        c.fill = GridBagConstraints.BOTH;
        c.weightx = c.weighty = 1;
        c.gridx = c.gridy = 0;
        int label = 1;

        add( new RedButton(Integer.toString(label++)), c); c.gridx++;
        add( new RedButton(Integer.toString(label++)), c); c.gridx++;
        add( new RedButton(Integer.toString(label++)), c); c.gridx++;
        add( new RedButton(Integer.toString(label++)), c);

        c.gridx=0; 
        c.gridy++;
        add( new RedButton(Integer.toString(label++)), c); c.gridx++;
        add( new RedButton(Integer.toString(label++)), c); c.gridx++;
        add( new RedButton(Integer.toString(label++)), c); c.gridx++;
        add( new RedButton(Integer.toString(label++)), c);

        c.gridx=0; 
        c.gridy++;
        c.gridwidth=2;
        add( new RedButton(Integer.toString(label++)), c);
        c.gridwidth=1;
        c.gridx+=2; 
        add( new RedButton(Integer.toString(label++)), c);
        c.gridx++; 
        c.gridheight=2;
        add( new RedButton(Integer.toString(label++)), c);
        c.gridheight=1;

        c.gridx=0; 
        c.gridy++;
        add( new RedButton(Integer.toString(label++)), c);
        c.gridx++; 
        c.gridwidth=2; 
        add( new RedButton(Integer.toString(label++)), c);
    }

    public static void main(String[] args) {
        AppletFrame.frame(new GridBagLayoutTest());
    }
}
