
import java.awt.*;
import java.applet.Applet;

/** Complex demonstration of GridBagLayout 
 *
 *  shows result of changing gridwidth and gridheight,
 *  anchor, fill, insets, ipad and weight 
 *
 */
public class GridBagLayoutTest2 extends Applet
{
    class RedButton extends java.awt.Button {
        public RedButton(String label) {
            super(label);
            setBackground(Color.red);
        }
    }

    public void init() {
        setFont(new Font("SansSerif",Font.PLAIN,9));
        setLayout(new GridBagLayout());
        GridBagConstraints  c  = new GridBagConstraints();
        c.gridwidth = c.gridheight=1;
        c.fill = GridBagConstraints.BOTH;
        c.weightx = c.weighty = 1;
        c.gridx = c.gridy = 0;
        c.fill = GridBagConstraints.VERTICAL;
        add(new RedButton("fill=Vertical"), c);
        c.fill = GridBagConstraints.BOTH;
        c.gridx++;
        c.fill = GridBagConstraints.NONE;
        add(new RedButton("fill=None"), c);
        c.gridx++;
        c.anchor = GridBagConstraints.SOUTHEAST;
        add(new RedButton("fill=None, Anchor=SE"), c);
        c.gridx++;
        c.anchor = GridBagConstraints.NORTH;
        c.fill = GridBagConstraints.HORIZONTAL;
        add(new RedButton("fill=Horizontal, Anchor=N"), c);
        c.anchor = GridBagConstraints.CENTER;

        c.fill = GridBagConstraints.NONE;
        c.gridx=0; 
        c.gridy++;
        c.ipadx = 30;
        add(new RedButton("fill=None, ipadx=30"), c);
        c.gridx++;
        c.ipadx = 0;
        c.ipady = 15;
        add(new RedButton("*"), c);
        c.ipady = 0;
        c.fill = GridBagConstraints.BOTH;

        c.gridx++;
        c.insets = new Insets(2,2,2,2);
        add(new RedButton("inserts=2,2,2,2"), c);
        c.gridx++;
        c.insets = new Insets(10,10,10,10);
        add(new RedButton("inserts=10,10,10,10"), c);
        c.insets = new Insets(0,0,0,0);

        c.gridx=0; 
        c.gridy++;
        c.gridwidth=2;
        add(new RedButton("gridwidth=2"), c);
        c.gridwidth=1;
        c.gridx+=2; 
        c.weighty=2;
        add(new RedButton("weighty=2"), c);
        c.weighty=1;
        c.gridx++; 
        c.gridheight=2;
        add(new RedButton("gridheight=2"), c);
        c.gridheight=1;

        c.gridx=0; 
        c.gridy++;
        c.weightx = c.weighty = 0;
        add(new RedButton("weightx=weighty=0"), c);
        c.gridx++; 
        c.gridwidth=2; 
        c.weightx=1;
        add(new RedButton("gridwidth=2, weighty=0"), c);
        c.gridwidth=1;

    }

}
