import java.lang.reflect.*;
import java.io.*;
import java.util.*;

/** Demonstration of reflection package
 *
 * Read list of class names from standard input
 * Invoke main methods of those classes
 */

public class InvokeMain {
    public static void main(String[] a) throws Exception {

        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String s;
        Class [] argsTypeForMain = new Class[1];
        argsTypeForMain[0] = a.getClass();	
        while ((s = in.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(s," \t");
            if (!st.hasMoreTokens()) continue;
            String className = st.nextToken();
            try {
                int count = st.countTokens();
                String[] args = new String[count];
                for(int i=0; i < count; i++) args[i] = st.nextToken();

                Class classToInvoke = Class.forName(className);
                Object[] argumentsToInvoke = new Object[1];  
                argumentsToInvoke[0] = args;

Method mainMethod = classToInvoke.getMethod("main",argsTypeForMain);
                System.out.println("Invoking " + className + ".main("+args+")");
                mainMethod.invoke(null, argumentsToInvoke);
            }
            catch (Exception e) {
                System.out.println("Error invoking main of " + className + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
