/** Demonstration of building a linkedList class in Java */

public class LinkedList {

    // Keep this private; no one else should see our implementation
    private static class Node { 
        Object value; Node next;
        Node(Object v) { value=v; next=null; }
    };

    // Put this here so it is clear that this is the Transformer for LinkedLists
    public static interface Transformer { 
        public Object transform(Object v); 
    }

    Node head,tail;
    public String toString() {
        StringBuffer result = new StringBuffer("(");
        for(Node n = head; n!= null; ) {
            result.append(n.value);
            n = n.next;
            if (n != null) result.append(",");
        }
        result.append(")");
        return result.toString();
    }
    public LinkedList reverse() {
        LinkedList result = new LinkedList();
        for(Node n = head; n != null; n = n.next)
            result.prepend(n.value);
        return result;
    }

    public void applyTransformer(Transformer t) {
        for(Node n = head; n != null; n = n.next) 
            n.value = t.transform(n.value);
    }
    public void append(Object v) {
        Node n = new Node(v);
        if (tail == null) head=n;
        else tail.next = n;
        tail = n;
    }
    public void prepend(Object v) {
        Node n = new Node(v);
        if (tail == null) tail=n;
        n.next = head;
        head = n;
    }

    public static void main(String [] args) {
        LinkedList test = new LinkedList();
        test.append("A"); test.append("B"); test.append("C");
        System.out.println(test.reverse());
    }
}

