/** Exhaustive test of method and variable overriding in Java */

public class Override {
    public static class A {
        public String f(A x) { return "A.f(A) "; }
        public String f(B x) { return "A.f(B) "; }
        public static String g(A x) { return "A.g(A) "; }
        public static String g(B x) { return "A.g(B) "; }
        public String h = "A.h";
        public String getH() { return "A.getH():" + h; }
    }

    public static class B extends A {
        public String f(A x) { return "B.f(A)/" + super.f(x); }
        public String f(B x) { return "B.f(B)/" + super.f(x); }
        public static String g(A x) { return "B.g(A) "; }
        public static String g(B x) { return "B.g(B) "; }
        public String h = "B.h"; 
	public String getH() { return "B.getH():" + h + "/" + super.h; 
        }
    }

    public static void main (String[] args) {

        A a = new A(); A ab = new B(); B b = new B();

        System.out.println( a.f(a) + a.f(ab) + a.f(b) );
        System.out.println( ab.f(a) + ab.f(ab) + ab.f(b) );
        System.out.println( b.f(a) + b.f(ab) + b.f(b) );
        System.out.println();
        // 
        // A.f(A) A.f(A) A.f(B) 
        // B.f(A)/A.f(A) B.f(A)/A.f(A) B.f(B)/A.f(B) 
        // B.f(A)/A.f(A) B.f(A)/A.f(A) B.f(B)/A.f(B) 

        System.out.println( a.g(a) + a.g(ab) + a.g(b) );
        System.out.println( ab.g(a) + ab.g(ab) + ab.g(b) );
        System.out.println( b.g(a) + b.g(ab) + b.g(b) );
        System.out.println();
        // 
        // A.g(A) A.g(A) A.g(B) 
        // A.g(A) A.g(A) A.g(B) 
        // B.g(A) B.g(A) B.g(B) 

        System.out.println( a.h  +" "+ a.getH());
        System.out.println( ab.h  +" "+ ab.getH());
        System.out.println( b.h  +" "+ b.getH());
        // 
        // A.h A.getH():A.h
        // A.h B.getH():B.h/A.h
        // B.h B.getH():B.h/A.h
    }
}
