import java.applet.Applet;
import java.awt.*;
import java.util.Date;

public class Timer extends FlickerFreeApplet implements Runnable {
    private Font f;
    private FontMetrics  fm;
    private long target;
    private Thread timer;
    private boolean running  =false;
    private boolean countDown = true;
    private long start;
    private long duration = 15*60*1000;
    private boolean soundNotPlayed = true;
    private boolean soundLoaded = false;

    public void init() {
        try {
            String bgColor = getParameter("bgColor");
            if (bgColor == null) bgColor = "ffffff";
            setBackground(new Color(Integer.parseInt(bgColor,16)));
        }
        catch (Exception e) {
            System.out.println("bg color exception" + e);

            setBackground(Color.white);

        }

        duration = 60*1000*Integer.getInteger("duration",25).intValue();
        if (duration == 0) duration = 16*1000;

        String fontName = getParameter("fontName");
        if (fontName == null) fontName="TimesRoman";
        int fontSize = Integer.getInteger("fontSize",18).intValue();
        f = new Font(fontName,Font.BOLD,fontSize);
        if (f == null) {
            System.out.println("Font not found: " + fontName 
                + "(" + fontSize +")");
            f = new Font("TimesRoman",Font.BOLD,12);
        }
        setFont(f);
        fm = getFontMetrics(f);
    }

    public void start() {
        if(timer == null)
        {
            timer = new Thread(this);
            timer.start();
        }
    }

    public void stop() {
        timer = null;
    }

    public boolean handleEvent(Event e) {
        if (e.id == Event.MOUSE_DOWN) {
            if (running) {
                running = false;
            } 
            else {
                running = true;
                soundNotPlayed = true;
                start = System.currentTimeMillis();
            }
            repaint();

            return true;
        }
        return super.handleEvent(e);
    }

    public void run() {
        while (true) {
            synchronized (this) {
                if (timer == null) break;
            }
            try { 
                Thread.sleep(900); 
            } 
            catch (InterruptedException e){ 
            }
            if (running) repaint();
        }
    }

    public void paint(Graphics g)
    {
        String msg;
        fm = g.getFontMetrics();

        if (running) {

            long secondsRemaining = (start + duration - System.currentTimeMillis())/1000;

            if (secondsRemaining > duration/8000) g.setColor(Color.green);
            else if (secondsRemaining > 0) g.setColor(Color.yellow);
            else g.setColor(Color.red);
            if (!soundLoaded || secondsRemaining < -5 && soundNotPlayed) {
                try {
                    play(getCodeBase(), "audio/cowbell.au");
                }
                catch (Exception e) {
                    System.out.println("Sound exception: " + e);
                }				
                soundLoaded = true;
                soundNotPlayed = false;			
            }

            msg = " ";
            if (secondsRemaining < 0) {
                secondsRemaining = -secondsRemaining;
                msg = "- ";
            }

            long secs = secondsRemaining%60;
            long mins = secondsRemaining/60%60;
            long hrs = secondsRemaining/3600%24;
            long days = secondsRemaining/3600/24;

            if (days > 0) msg += days + ":";
            if (hrs > 0 && hrs <10) msg += " " + hrs + ":";
            else if (hrs >= 10) msg += hrs + ":";
            if (mins > 0 && mins <10) msg += " " + mins + ":";
            else if (mins >= 10) msg += mins + ":";
            if (secs <10) {
                if (mins > 0) msg += "0" + secs;
                else msg += " " + secs;
            }
            else msg += secs;
        } 
        else {
            msg = "Click";
            g.setColor(Color.blue);
        }

        Dimension d = size();
        int msgWidth = fm.stringWidth(msg);
        int msgHeight = fm.getAscent() + fm.getDescent();
        int left = (d.width-msgWidth)/2;
        int top = (d.height-(fm.getAscent()+fm.getDescent()))/2;
        int baseLine = top + fm.getAscent();
        int bottom = baseLine + fm.getDescent(); 

        g.drawString(msg, left, baseLine);
    }
}
