// CMSC427
// File: Polyline.pde
// R. Eastman
// Polyline class

public class Polyline {
  
  int pick = -1;
  boolean isClosed = false;
  ArrayList<Point> pline = new ArrayList<Point>();
  
  // Add point to Polyline
  void add(float mx, float my) {
    pline.add(new Point(mx,my));
  }
  
  // Display Polyline
  void draw() {
    
    beginShape();
    for (int i = 0; i < pline.size(); i++) {
        Point p = pline.get(i);
        vertex( p.x, p.y );
        }
    if (isClosed) 
        endShape(CLOSE);
    else
        endShape();
    if (pline.size() > 0) {
      Point p = pline.get(0);
      fill(0,0,255,128);
      ellipse(p.x,p.y,15,15);
    }
   fill(255,0,0,128);
   for (int i = 1; i < pline.size(); i++) {
     Point q = pline.get(i);
     ellipse(q.x,q.y,10,10);
      } 
   if (pick != -1) {
     fill(0,255,0, 128);
     Point m = pline.get(pick);
     ellipse(m.x,m.y,18,18);
   }
  }
  
  // Set to polygon
  void close() {
    isClosed = true;
  }
  
  // Set to polyline
  void open() {
    isClosed = false;
  }
  
  // Release the picked point
  void pickRelease() {
    pick = -1;
  }
  
  // Update pick point location
  void pickUpdate(float mx, float my) {
    if(pick != -1) {
     Point p = pline.get(pick);
     p.x = mouseX;
     p.y = mouseY;
    }
  }
  
  // Set the picked point
  void pick(float mx, float my) {
    for (int i = 0; i < pline.size(); i++) {
    Point p = pline.get(i);
    if ( dist(p.x,p.y,mouseX,mouseY) < 8)
       pick = i;
    }
  }

// Internal utility class
class Point {
  public float x,y;
  public Point( float _x, float _y ) {
      x = _x;
      y = _y;
  }
}
}