function PrintFlap(f, label, linelength)
%PrintFlap   Prints a flap.
%    PrintFlap(F) prints the array of the flap F to F.Rlevel digits.
%    The maximum number of characters per line is the global variable
%    FlapLineLength, or 80 if FlapLineLength has not been initialized.
%
%    PrintFlap(F, LABEL) prints the string LABEL before F.  Note that
%    FPRINTF is used to print LABLE, which means that you can use
%    \n to introduce new lines.  In particular if LABEL is not empty
%    it should end with \n, unless you want the printout to start
%    on the same line as LABEL.
%
%    PrintFlap(F, LABLE, LINELENGTH) prints as above with the
%    specified LINELENGTH overriding the defaults.  To supress
%    the label use ''.

global FlapRlevel FlapLineLength
if nargin < 3
   if isempty(FlapLineLength)
      linelength = 80;
   else
      linelength = FlapLineLength;
   end
end
[m,n] = size(f.d);
if nargin==1
   label = '';
end
if m==0 | n==0
   fprintf([label '\n']);
   fprintf('[%d, %d] empty array\n', m, n);
   return
else
   PrintAry(f.d, f.Rlevel, label, linelength);
end


