function f = flap(a, Rlevel)
%FLAP  Constructor for Flap.
%
%   f = flap creats a flap with F.Rlevel=16 and F.d=[];
%
%   f = flap(a, Rlevel), where a is a flap, creates a flap with f.d
%      equal to a.d rounded to Rlevel.  For the exact protocol, see the
%      code.  If Rlevel is not present, FlapRlevel is used.
%
%   f = flap(a, Rlevel), where a is a is a double, creates a flap with
%       f.d equal to a rounded to Rlevel.  For the exact protocol, see
%       the code.  If Rlevel is not present, FlapRlevel is used.

global FlapRlevel;

if nargin == 0
   f.Rlevel = 16;
   f.d = [];
   f = class(f, 'flap');
   return;

elseif nargin == 1
   Rlevel = FlapRlevel;

elseif nargin == 2
   if (Rlevel<1 | Rlevel>16 | Rlevel~=round(Rlevel))
      error('Flap: Rlevel must be an integer in 1:16');
   end

else
   error('Flap: Too many input arguments in flap.')
end

if isa(a, 'flap')
   f = a;

   if  Rlevel<=14
      if Rlevel < f.Rlevel
         f.Rlevel = Rlevel;
         f.d =  FlapRound(f.d, Rlevel);
      end

   elseif Rlevel==15
      f.Rlevel = 0;
      f.d = double(single(f.d));

   elseif Rlevel==16
      f.Rlevel = 16;
   end

elseif isa(a, 'double')

   if  Rlevel<=14
      f.Rlevel = Rlevel;
      f.d = FlapRound(a, Rlevel);

   elseif Rlevel==15
      f.Rlevel = 15;
      f.d = double(single(a));

   elseif Rlevel==16
      f.Rlevel = 16;
      f.d = a;
   end
   f = class(f, 'flap');

else
   error('Flap: First argument must be double or flap.');
end

   

      

