function g = horzcat(varargin)
%HORZCAT   Horizontal concatenation.
%   G = HORZCAT(F1, F2, ...) returns a flap G such that
%   G.d = [F1.d, F2.d, F3.d, ...].  G.Rlevel is adjusted appropriately.

global FlapRlevel;

g = flap;
g.Rlevel = 0;

for i=1:length(varargin)
   f = flap(varargin{i});
   g.d = [g.d, f.d];
   g.Rlevel = max([g.Rlevel, f.Rlevel]);
end


