function [u, nu] = housegen(x)
%HOUSEGEN   Generate a Householder transformation.
%   [u, nu] = housegen(x), where x is a flap column vector
%   computes a flap column vector u with norm(u) = sqrt(2) such that
%   (I - u*u')*x = nu*e1, where e1 is the first unit
%   vector.  
%
%   [u, nu] = housegen(x), where x is a flap column vector
%   computes a flap column vector u with norm(u) = sqrt(2) such that
%   (I - u*u')*x' = nu*e1, where e1 is the first unit
%   vector.


x = flap(x);
[u, nu] = FlapHousegen(x.d);
u = flap(u);
nu = flap(nu);

   