function[L, U, P] = lud(F);
%LUD   LU factorization.
%   [L, U, P] = LUD(F) returns a unit lower triangular flap L,
%   and upper triangualr flap U and a permutation flap P such
%   that P*F = L*U.  F can be rectangular.

F = flap(F);

A = F.d;
[m, n] = size(A);
P = eye(m);
for k=1:min(m-1, n)
   [pvtel, p] = max(abs(A(k:m,k)));
   p = p+k-1;
   if (pvtel == 0), continue, end;
   if p ~= k
      A([k,p], 1:n) = A([p,k], 1:n);
      P([k,p], 1:m) = P([p,k], 1:m);
   end
   A(k+1:m,k) = FlapRound(A(k+1:m,k)/A(k,k));
   temp = FlapRound(A(k+1:m,k)*A(k,k+1:n));
   A(k+1:m,k+1:n) = FlapMinus(A(k+1:m,k+1:n), temp);
end

if m > n
   L = tril(A,-1);
   L(1:n,1:n) = L(1:n,1:n) + eye(n);
   U = triu(A(1:n,1:n));
else
   L = tril(A(1:m,1:m),-1) + eye(m);
   U = triu(A); 
end
L = flap(L);
U = flap(U);
P = flap(P);

