function C = mtimes(A, B)
%MTIMES   implements *
%   H = MTIMES(F, G) returns a flap such that H.d = F.d*G.d.  H.Rlevel
%   is adjusted accordingly.
%
%   The dimensions of F.d and G.d must be consistent for matrix
%   multiplication.  However, if F.d or G.d is 1x1, MTIMES implements
%   the multiplication of a matrix by a scalar.

global FlapRlevel;

A = flap(A);
B = flap(B);
C = flap;
C.Rlevel = FlapRlevel;

[l, m] = size(A.d);
[mm, n] = size(B.d);

% Special cases.

if (l==1 & m==1) | (mm==1 & n==1)
   C.d = FlapRound(A.d*B.d);
   return
end

if m ~= mm
   error('Flap: Inconsistent dimensions.')
end

% Matrix multiplication.  Uses a BLAS2 method.


C.d = zeros(l,n);

for k=1:m
  C.d = FlapRound(C.d + FlapRound(A.d(:,k)*B.d(k,:)));
end



