function [u, v] = rotapp(c, s, a, b)
%ROTAPP   Apply a plane rotation.
%   [u, v] = rotapp(c, s, a, b) computes the product
%
%      |   c        s    |  | a |     | u |
%      |                 |  |   |  =  |   |
%      |-conj(s)  conj(c)|  | b |     | v |
%
%   where a and b (in most applications) are row vectors.
%
%   [u, v] = rotapp(conj(c), conj(s), a, b) computes the product
%
%   | a  b | |   c        s    |'    | u  v |
%            |                 |  =
%            |-conj(s)  conj(c)|
%
%   where a and b are column vectors.

c = flap(c);
s = flap(s);
a = flap(a);
b = flap(b);

[u, v] = rotapp(c.d, s.d, a.d, b.d);

u = flap(u);
v = flap(v);
