function [c, s, nu] = rotgen(a, b)
%ROTGET   Generate a plane rotation.
%   [c, s, nu] = rotgen(a, b) computes quantities c and s
%   satisfying norm([c s]) = 1 such that
%
%      |   c        s    |  | a |     | nu |
%      |                 |  |   |  =  |    |       (*)
%      |-conj(s)  conj(c)|  | b |     |  0 |
%
%   nu  is equal to norm([a, b]).  The matrix in (*) is unitary
%   (orthogonal when a and b are real) and is called a plane
%   or Givens rotation.

a = flap(a);
b = flap(b);
[c, s, nu] = rotgen(a.d, b.d)
c = flap(c);
s = flap(s);
nu = flap(nu);
