function f = subsasgn(f, S, g)
%SUBSASGN   subscripted assignment.
%   This function is called when a subscripted assignment is made to a
%   a flap.   Examples:
%
%   F(:,2) = G, where G is a flap, Replaces the second column of
%   F by G.d.  F.Rlevel is replaced by max(F.Rlevel, G.Rlevel).
%
%   F(:,2) = G, where G is a double array replaces the second column
%   of F with G rounded to FlapRlevel.  F.Rlevel is replace by
%   max(F.Rlevel, FlapRlevel).

global flapDigits

f = flap(f);

switch S.type

case '()'
   g = flap(g);
   f.d(S.subs{:}) = g.d;
   f.Rlevel = max([f.Rlevel, g.Rlevel]);
case '.'
   if (S.type == 'd')
      g = flap(g);
      f.d = g.d;
   else
      error('Flap: Illegal assign reference in subsasgn.')
   end
end
