function g = subsref(f, S)
%SUBSREF   Subscripted reference.
%   G = SUBSREF(F, S) is used for three purposes.  First to extract a
%   portion of F.d and assign to G.d; e.g., G = F(:,2).  Second, to
%   extract F.d and F.Rlevel.  Third, to subscript F.d; e.g.,
%   F.d(:,1).  For more see SUBSREF.

global FlapRlevel;

if size(S,2) == 1

f = flap(f);

   switch S.type

      case '()'  % Create new flap.
        g = flap(f);
        g.Rlevel = f.Rlevel;
        g.d = g.d(S.subs{:});

      case '.'  % Produce the d or digits field.
         switch S.subs
            case 'd'
               g = f.d;
            case 'Rlevel'
               g = f.Rlevel;
            otherwise
               error(['Flap: Illegal field ' S.subs '.'] )
         end

      otherwise
         error('Flap: Illegal cell reference.')
   end

elseif size(S,2) == 2 % Subscript reference to f.d

   if S(1).type == '.' & S(1).subs == 'd' & S(2).type == '()'
      g = f.d(S(2).subs{:});
   else
      error('Flap: Illegal subscript.');
   end
else
   error('Flap: Illegal subscript.')
end

