function g = vertcat(varargin)
%VERTCAT   Vertical concatenation.
%   G = VERTCAT(F1, F2, F3, ...) returns a flap G such that
%   G.d = [F1.d, F2.d, F3.d, ...].  G.Rlevel is adjusted appropriately.

   global FlapRlevel;

   g = flap;
   g.Rlevel = 0;
   
   for i=1:length(varargin)
      h = flap(varargin{i});
      g.d = [g.d; h.d];
      g.Rlevel = max([g.Rlevel, h.Rlevel]);
   end

return 
