function A = FlapHouseappl(u, A)
%FlapHouseappl   Premultiply a Householder transformation.
%
%   A = houseappl(u, A) computes A - u*(u'*A), where u is a
%   column vector,  rounding to FlapRlevel after
%   each arithmetic operation.

[m,n] = size(A);

v = zeros(1,n);
for i=1:m
   v = FlapPlus(v, FlapRound(u(i)'*A(i,:)));
end

A = FlapMinus(A,  FlapRound(u*v));
