function A = FlapHouseappr(u, A)
%FlapHouseappr   Postmultiply a Householder transformation.
%
%   A = houseappl(u, A) computes A - (A*u)*u', where u is a
%   column vector,  rounding to FlapRlevel after
%   each arithmetic operation.


[m,n] = size(A);

v = zeros(m,1);
for j=1:n
   v = FlapPlus(v, FlapRound(u(j)*A(:,j)));
end

A = FlapMinus(A,  FlapRound(v*u'));
