function [u, nu] = FlapHousegen(x)
%FlapHouseGen   Generate a Householder transformation.
%   [u, nu] = housegen(x), where x is a *column* vector
%   computes a column vector u with norm(u) = sqrt(2) such that
%   (I - u*u')*x = nu*e1, where e1 is the first unit
%   vector.  Each arithmetic operation is rounded to FlapRlevel.
%
%   [u, nu] = housegen(x), where x is a *row* vector
%   computes a column vector u with norm(u) = sqrt(2) such that
%   (I - u*u')*x' = nu*e1, where e1 is the first unit
%   vector.  Each arithmetic operation is rounded to FlapRlevel.


[m,n] = size(x);
if m>0 & n==1
   u = x;
elseif m==1 & n>0
   u = x';
else
   error('FlapBase: Input to housegen must be a nonempty vector')
end
   

nu = FlapRound(norm(u));

if nu == 0; u(1) = sqrt(2); return, end

rho = sign(u(1));
if rho==0, rho=1; end

nu = FlapRound(rho*nu);
u =  FlapRound(u/nu);
u(1) = FlapPlus(1,u(1));

u = FlapRound(u/FlapRound(sqrt(abs(u(1)))));
nu = -nu;
