function [u, v] = FlapRotapp(c, s, a, b)
%FlapRotapp   Apply a plane rotation.
%   [u, v] = rotapp(c, s, a, b) computes the product
%
%      |   c        s    |  | a |     | u |
%      |                 |  |   |  =  |   |
%      |-conj(s)  conj(c)|  | b |     | v |
%
%   where a and b (in most applications) are row vectors.
%
%   [u, v] = rotapp(conj(c), conj(s), a, b) computes the product
%
%   | a  b | |   c        s    |'    | u  v |
%            |                 |  = 
%            |-conj(s)  conj(c)| 
%
%   where a and b are column vectors.  Each arithmetic operation in
%   the caluclation is rounded to FlapRlevel.

u = FlapRound(FlapRound(c*a) + FlapRound(s*b));
v = FlapRound(FlapRound(conj(c)*b) - FlapRound(conj(s)*a));
