function [c, s, nu] = FlapRotgen(a, b)
%FlapRotgen   Generates a plane rotation.
%   [c, s, nu] = rotgen(a, b) computes quantities c and s
%   satisfying norm([c s]) = 1 such that
%
%      |   c        s    |  | a |     | nu |
%      |                 |  |   |  =  |    |       (*)
%      |-conj(s)  conj(c)|  | b |     |  0 |
%
%   nu  is equal to norm([a, b]).  The matrix in (*) is unitary
%   (orthogonal when a and b are real) and is called a plane
%   or Givens rotation. Each arithmetic operation in the
%   computation is rounded to FlapRlevel.

absa = FlapRound(abs(a));
absb = FlapRound(abs(b));
s = FlapRound(absa + absb);
if s==0
   c = 1; s = 0; nu = 0;
   return
end
as2 = FlapRound(FlapRound(absa/s)^2);
bs2 = FlapRound(FlapRound(absb/s)^2);

nu = FlapRound(s*FlapRound(sqrt(FlapRound(as2+bs2))));

c = conj(FlapRound(a/nu));
s = conj(FlapRound(b/nu));

