function y = FlapRound(x, Rlevel)
%FlapRound   Rounds a real or complex array.
%
%   Y = FlapRound(X) returns the array X rounded to FlapRlevel.
%
%
%   Y = FlapRound(X, RLEVEL) returns the array X rounded to Rlevel.

% Pete Stewart
% May  2 2008

global FlapRlevel


if nargin == 1
   Rlevel = FlapRlevel;
end

if Rlevel<1 | Rlevel >16 | round(Rlevel)~=Rlevel
   error('Flap: Rlevel must be an positive integer in 1:16')
end

if (Rlevel == 16)
   y = x;
   return
end

if (Rlevel == 15)
   y = double(single(x));
   return
end

[m, n] = size(x);

if (isreal(x))

   xx = abs(x) + (x==0);
   s = (10*ones(m,n)).^(Rlevel - ceil(log10(xx)));
   xx = round(s.*xx)./s;
   y = sign(x).*xx.*(x~=0);
else

   xr = real(x);
   xx = abs(xr) + (xr==0);
   s = (10*ones(m,n)).^(Rlevel - ceil(log10(xx)));
   xx = round(s.*xx)./s;
   xr = sign(xr).*xx.*(xr~=0);

   xi = imag(x);
   xx = abs(xi) + (xi==0);
   s = (10*ones(m,n)).^(Rlevel - ceil(log10(xx)));
   xx = round(s.*xx)./s;
   xi = sign(xi).*xx.*(xi~=0);

   y = complex(xr, xi);
end


