%FlapStartup   Declares and initializes  FlapRlevel and FlapLineLength.
%   This script creates the global variables FlapRlevel and 
%   and FlapRlevel and asks the the caller for an initial value.  Fails
%   if the input is not an integer in 0:16.

global FlapRlevel FlapLineLength
   
FlapRlevel = input('Enter FlapRlevel (default 5): ');

if isempty(FlapRlevel), FlapRlevel = 5; end

if FlapRlevel<1 | FlapRlevel>16 | FlapRlevel~=round(FlapRlevel)
   disp('FlapRlevel must be an integer in 1:16.  Try again.')
end

FlapLineLength = input('Enter FlapLineLength (default 80): ');

if isempty(FlapLineLength), FlapLineLength = 80; end

if FlapLineLength<=0 | FlapLineLength~=round(FlapLineLength)
   disp('FlapLineLength must be a positive integer.  Try again.')
end

