function PrintAry(ary, Rlevel, label, LineLength)
%PrintAry    Prints a double array.
%    PrintAry(ARY, RLEVEL) prints the ARY to RLEVEL decimal digits.
%
%    PrintAry(ARY, RLEVEL, LABEL) prints the string LABEL before F.
%    Note that FPRINTF is used to print LABLE, which means that
%    you can use \n to introduce new lines.  In particular,
%    if LABLE is not empty it should end with \n, unless you want
%    the printout to start on the same line as LABEL.
%   
%    PrintAry(ARY, RLEVEL, LABLE, LINELENGTH)
%    Specifies a LINLENGTH to use is deciding how many items to
%    place on a line.  The default is 80.  To supress the LABLE
%    use an empty string: ''.

   if nargin > 4
      error('Too many arguments in PrintAry');
   end
   if nargin < 4
      LineLength = 80;
   end
   [m,n] = size(ary);
   if m==0 | n==0
      if nargin==2, fprintf(label), end;
      fprintf('[%d, %d] empty array\n', m, n);
      return
   end
   ilen = fix(log10(m))+2;
   jlen = fix(log10(n))+2;
   reald = isreal(ary);

   if Rlevel<1 | Rlevel>16 | round(Rlevel)~=Rlevel
      error('Illegal Rlevel in PrintAry');
   end
   if Rlevel == 15
      Rlevel = 7;
   elseif Rlevel == 16  % Should be removed if we decide to
      Rlevel = 16;      % print out doubles to 16 digits.
   end
   if reald
      ItemLen = 7+Rlevel;
      fmt = ['%' sprintf('%d', 7+Rlevel) '.' ...
              sprintf('%d', Rlevel-1) 'e'];
   else
      ItemLen = 14+2*Rlevel;
      fmt = [' %' sprintf('%d', 6+Rlevel) '.'...
                  sprintf('%d', Rlevel-1) 'e %s%'...
                  sprintf('%d', 6+Rlevel) '.' ...
                  sprintf('%d', Rlevel-1) 'ei'];
   end
   nitem = fix((LineLength - ilen - jlen)/ItemLen);
   fij1 = ['%' sprintf('%d', ilen-1) 'd %' sprintf('%d', jlen-1) 'd:'];
   skip = repmat(' ', 1, ilen);
   fij2 = [ skip '%' sprintf('%d', jlen-1) 'd:'];
   fi = [ '%' sprintf('%d', ilen) 'd:'];
   if nargin>=3 fprintf(label), end;
   for i=1:m
      jl = 1;
      while true
         ju = min([jl+nitem-1, n]);
         s = '';
         if n <= nitem 
            if m>1
               s = [s, sprintf(fi,i)];
            end
         elseif jl == 1,
            s = [s, sprintf(fij1, i, jl)];
         else

%             s = [s, sprintf(fij1, i, jl)];
% Uncomment the above statement and comment the one below to 
% get more informative output for matrices with very long rows.
            s = [s, sprintf(fij2, jl)];
         end
         for j=jl:ju
            if reald
               s = [s,sprintf(fmt, ary(i,j))];
            else
               if imag(ary(i,j))<0
                  sgn = '-';
               else
                  sgn = '+';
               end
               s = [s,sprintf(fmt, real(ary(i,j)), sgn, abs(imag(ary(i,j))))];
            end
         end
         disp(s)
         jl = ju+1;
         if jl > n, break; end
      end
   end

