function [] = SetFlapRlevel(Rlevel)
%SetFlapRlevel   Sets the global rounding level.
%   SetFlapRlevel(Rlevel) sets FlapRlevel to Rlevel, provided
%   Rlevel is an integer in 0:16.  Otherwise an error return is given.

global FlapRlevel

if (Rlevel<1 | Rlevel>16 | Rlevel~=round(Rlevel))
   error('Rlevel must be an integer in 1:16');
end

FlapRlevel = Rlevel;
