
%Read the samples from the audio file
sampleRate = 100;
timeDuration = 30; %sec
maxFrequency = 100; %Hz
timeTicks = 0:1/sampleRate:timeDuration;
chirpSound = chirp(timeTicks, 0, timeDuration, maxFrequency);

%Play sound
%sound(chirpSound, sampleRate);

%Plot the sound
% figure;
% plot(timeTicks, chirpSound);
% ax = gca;
% F_size = 20;
% ax.FontSize = F_size;
% xlabel('Time (sec)', 'FontSize', F_size);
% ylabel('Amplitude', 'FontSize', F_size);

%Plot spectrogram
Window = 100;
Overlap = 99;
NumFFT = 10000;
figure; spectrogram(chirpSound, Window, Overlap, NumFFT, sampleRate, 'yaxis');
ax = gca;
F_size = 20;
ax.FontSize = F_size;
xlabel('Time (sec)', 'FontSize', F_size);
ylabel('Frequency (kHz)', 'FontSize', F_size);