package cmsc420_f22;

// YOU SHOULD NOT MODIFY THIS FILE

import java.util.Scanner;
import java.util.ArrayList;

/**
 * Command handler. This reads a single command line, processes the command (by
 * invoking the appropriate method(s) on the data structure), and returns the
 * result as a string.
 */

public class Part0CommandHandler {

	ExpandingStack expandingStack; // dual list structure
	final int initialCapacity = 4; //

	/**
	 * Constructor.
	 */
	public Part0CommandHandler() {
		try {
			expandingStack = new ExpandingStack(4); // initialize with capacity 4
		} catch (Exception e) {
			System.err.println("Invalid stack capacity"); // this should never be invoked
		}
	}

	/**
	 * Process a single command and return the string output. Each command begins
	 * with a command followed by a list of arguments. The arguments are separated
	 * by colons (":").
	 * 
	 * @param inputLine The input line with the command and parameters.
	 * @return A string summary of the command's execution/result.
	 */
	public String processCommand(String inputLine) throws Exception {
		Scanner line = new Scanner(inputLine);
		line.useDelimiter(":"); // use ":" to separate arguments
		String output = new String(); // for storing summary output
		String cmd = (line.hasNext() ? line.next() : ""); // next command
		try {
			// -----------------------------------------------------
			// PUSH x
			// - push x onto stack
			// -----------------------------------------------------
			if (cmd.compareTo("push") == 0) {
				String x = line.next(); // item to push
				output += "push(" + x + "): ";
				expandingStack.push(x); // ... push it
				output += "successful" + System.lineSeparator();
			}
			// -----------------------------------------------------
			// POP
			// - pop and print
			// -----------------------------------------------------
			else if (cmd.compareTo("pop") == 0) {
				output += "pop: ";
				String x = expandingStack.pop(); // pop the stack
				if (x == null) throw new Exception("Error - Pop returns null result");
				output += x + System.lineSeparator(); // return its value
			}
			// -----------------------------------------------------
			// PEEK
			// - look at the i-th element from the top
			// -----------------------------------------------------
			else if (cmd.compareTo("peek") == 0) {
				int i = line.nextInt(); // which index to get
				output += "peek(" + i + "): ";
				String x = expandingStack.peek(i); // get it
				if (x == null) throw new Exception("Error - Peek returns null result");
				output += x + System.lineSeparator(); // return its value
			}
			// -----------------------------------------------------
			// SIZE
			// - how many elements are in the stack?
			// -----------------------------------------------------
			else if (cmd.compareTo("size") == 0) {
				int size = expandingStack.size(); // get the size
				output += "size: " + size + System.lineSeparator();
			}
			// -----------------------------------------------------
			// CAPACITY
			// - how many elements in the current array?
			// -----------------------------------------------------
			else if (cmd.compareTo("capacity") == 0) {
				int capacity = expandingStack.capacity(); // get the capacity
				output += "capacity: " + capacity + System.lineSeparator();
			}
			// -----------------------------------------------------
			// LIST
			// - list the stack top down
			// -----------------------------------------------------
			else if (cmd.compareTo("list") == 0) {
				ArrayList<String> list = expandingStack.list(); // get list of elements
				if (list == null) throw new Exception("Error - List returns a null result");
				output += "list:";
				for (int i = 0; i < list.size(); i++) { // and print them
					output += " " + list.get(i);
					if (i % 20 == 19) output += System.lineSeparator() + "     "; 
				}
				output += System.lineSeparator();
			}
			// -----------------------------------------------------
			// Unrecognized command
			// -----------------------------------------------------
			else {
				if (cmd.compareTo("") == 0)
					System.err.println("Error: Empty command line (Ignored)");
				else
					System.err.println("Error: Invalid command - \"" + cmd + "\" (Ignored)");
			}
			line.close();
		} catch (Exception e) { // exception thrown?
			String message = e.getMessage(); // get the associated error message
			if (message == null) { // there should be a message
				output += "Exception but no message. (Probably an error in your program)";
				System.err.print("Exception but no message. (Probably an error in your program)");
				e.printStackTrace(System.err);
			} else {
				output += "Failure due to exception: \"" + e.getMessage() + "\"" + System.lineSeparator();
			}
		} catch (Error e) { // error occurred?
			output += "Runtime error. (Probably an error in your program)";
			System.err.print("Runtime error. (Probably an error in your program)");
			e.printStackTrace(System.err);
		} finally { // always executed
			line.close(); // close the input scanner
		}
		return output; // return summary output
	}

}
