%This program records sounds from the laptop microphone and saves in a
%file.

filename = './testRecording.wav'; %Output sound filename
Fs = 8000 ; %Sampling rate
nBits = 16 ; %Number of bits per sample
nChannels = 1 ; %Number of audio channel, 1=Mono, 2=Stereo
ID = -1; % default audio input device
RecordDuration = 5; %Length of recording in seconds

%Create a recorder object
recObj = audiorecorder(Fs,nBits,nChannels,ID);

disp('Recording starts: Say something.')
recordblocking(recObj,RecordDuration); 
disp('Recording ends.')
disp('Processing data. Please wait.')
%Collect the samples from the object
soundData = getaudiodata(recObj);

if(1) %Plot the recorded sound
    %Plot the sound
    figure;
    plot(soundData);
    ax = gca;
    F_size = 20;
    ax.FontSize = F_size;
    xlabel('Sample number', 'FontSize', F_size);
    ylabel('Amplitude', 'FontSize', F_size);

    %Plot spectrogram
    Window = 1000;
    Overlap = 900;
    NumFFT = 5000;
    figure; spectrogram(soundData, Window, Overlap, NumFFT, Fs, 'yaxis');
    ax = gca;
    F_size = 20;
    ax.FontSize = F_size;
    xlabel('Time (sec)', 'FontSize', F_size);
    ylabel('Frequency (kHz)', 'FontSize', F_size);
end

if(1) %Play the recoded sound
    sound(soundData,Fs);
end

%Write the recording in a file
audiowrite(filename, soundData, Fs);
