package computerSys;

public class ComputerCopyDriver {

	public static void main(String[] args) {
		Computer first, second;

		first = new Computer("IBM", "IBMMouse");
		first.moveMouse(10, 20);
		System.out.println(first);

		System.out.println("Reference copy ===================");
		first = new Computer("IBM", "IBMMouse");
		first.moveMouse(10, 20);
		second = Computer.referenceCopy(first);
		second.moveMouse(0, 0);
		System.out.println(first);
		System.out.println(second);

		System.out.println("\nDeep copy ===================");
		first = new Computer("IBM", "IBMMouse");
		first.moveMouse(10, 20);
		second = Computer.deepCopy(first);
		second.moveMouse(0, 0);
		System.out.println(first);
		System.out.println(second);

		System.out.println("\nShallow copy ===================");
		first = new Computer("IBM", "IBMMouse");
		first.moveMouse(10, 20);
		second = Computer.shallowCopy(first);
		second.moveMouse(0, 0);
		System.out.println(first);
		System.out.println(second);
		
		System.out.println("\nNeeded copy ===================");
		first = new Computer("IBM", "IBMMouse");
		first.moveMouse(10, 20);
		second = Computer.efficientCopy(first);
		second.moveMouse(0, 0);
		System.out.println(first);
		System.out.println(second);
	}
}
