package computerSys;

public class Computer {
	private String name;
	private Mouse mouse;

	/* Allow us to create a Computer object; why we need it? */
	public Computer() {
	}

	public Computer(String name, String mouseBrand) {
		this.name = name;
		mouse = new Mouse(mouseBrand);
	}

	public String toString() {
		return name + ", " + mouse;
	}

	public void moveMouse(int x, int y) {
		mouse.changeCoordinates(x, y);
	}
	
	public static Computer referenceCopy(Computer computer) {
		return computer;
	}

	public static Computer deepCopy(Computer computer) {
		Computer answer = new Computer();

		answer.name = new String(computer.name);
		answer.mouse = Mouse.deepCopy(computer.mouse);

		return answer;
	}

	/* What is the problem? Sharing of the Mouse!    */
	/* Shallow copy is not good enough in this case. */
	public static Computer shallowCopy(Computer computer) {
		Computer answer = new Computer();

		answer.name = computer.name;
		answer.mouse = computer.mouse;

		return answer;
	}

	/* More efficient than deep copy providing a copy     */
	/* that can be modified without changing the original */
	public static Computer efficientCopy(Computer computer) {
		Computer answer = new Computer();

		answer.name = computer.name;
		answer.mouse = Mouse.deepCopy(computer.mouse);

		return answer;
	}
}
